using Microsoft.VisualBasic;
using Microsoft.VisualBasic.Compatibility;
using System;
using System.Collections;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
namespace AvaxCAD
{
    internal class FrmPrintPreview : System.Windows.Forms.Form 
    { 
        #region '"Windows Form Designer generated code "' 
        public FrmPrintPreview() : base() 
        { 
            
            if ( m_vb6FormDefInstance == null ) 
            { 
                if ( m_InitializingDefInstance ) 
                { 
                    m_vb6FormDefInstance = this; 
                } 
                else 
                { 
                    try 
                    { 
                        // For the start-up form, the first instance created is the default instance.
                        if ( System.Reflection.Assembly.GetExecutingAssembly().EntryPoint.DeclaringType == this.GetType() ) 
                        { 
                            m_vb6FormDefInstance = this; 
                        } 
                    } 
                    catch  
                    { 
                    } 
                } 
            } 
            // This call is required by the Windows Form Designer.
            InitializeComponent(); 
            
        } 
        // Form overrides dispose to clean up the component list.
        protected override void Dispose( bool Disposing ) 
        { 
            Preview1.Terminate(); 
            if ( Disposing ) 
            { 
                /* TRANSERROR: map static local variable to static field */ bool fTerminateCalled = false; 
                if ( !( fTerminateCalled ) ) 
                { 
                    fTerminateCalled = true; 
                } 
                if ( !( components == null ) ) 
                { 
                    components.Dispose(); 
                } 
            } 
            base.Dispose( Disposing ); 
        } 
        
        // Required by the Windows Form Designer
        private System.ComponentModel.IContainer components; 
        public System.Windows.Forms.ToolTip ToolTip1; 
        public System.Windows.Forms.Button cmdPrintSetup; 
        public System.Windows.Forms.Button cmdPDF; 
        public System.Windows.Forms.Button cmdPrintPrev; 
        public System.Windows.Forms.Button cmdPrintNext; 
        public System.Windows.Forms.Button cmdPrintPrint; 
        public System.Windows.Forms.TextBox TXT_unitMM; 
        public AxMSComDlg.AxCommonDialog CommonDialog1; 
        public System.Windows.Forms.Label Label1; 
        public System.Windows.Forms.Label Label2; 
        public System.Windows.Forms.Label Label3; 
        // NOTE: The following procedure is required by the Windows Form Designer
        // It can be modified using the Windows Form Designer.
        // Do not modify it using the code editor.
        internal AxavPreview.AxPreview Preview1; 
        [ System.Diagnostics.DebuggerStepThrough() ]
        private void InitializeComponent() 
        { 
            this.components = new System.ComponentModel.Container(); 
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager( typeof( FrmPrintPreview ) ); 
            this.ToolTip1 = new System.Windows.Forms.ToolTip( this.components ); 
            this.cmdPrintSetup = new System.Windows.Forms.Button(); 
            this.cmdPDF = new System.Windows.Forms.Button(); 
            this.cmdPrintPrev = new System.Windows.Forms.Button(); 
            this.cmdPrintNext = new System.Windows.Forms.Button(); 
            this.cmdPrintPrint = new System.Windows.Forms.Button(); 
            this.TXT_unitMM = new System.Windows.Forms.TextBox(); 
            this.CommonDialog1 = new AxMSComDlg.AxCommonDialog(); 
            this.Label1 = new System.Windows.Forms.Label(); 
            this.Label2 = new System.Windows.Forms.Label(); 
            this.Label3 = new System.Windows.Forms.Label(); 
            this.Preview1 = new AxavPreview.AxPreview(); 
            ( ( System.ComponentModel.ISupportInitialize )( this.CommonDialog1 ) ).BeginInit(); 
            ( ( System.ComponentModel.ISupportInitialize )( this.Preview1 ) ).BeginInit(); 
            this.SuspendLayout(); 
            // 
            // cmdPrintSetup
            // 
            this.cmdPrintSetup.BackColor = System.Drawing.SystemColors.Control; 
            this.cmdPrintSetup.Cursor = System.Windows.Forms.Cursors.Default; 
            this.cmdPrintSetup.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.cmdPrintSetup.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.cmdPrintSetup.Location = new System.Drawing.Point( 69, 0 ); 
            this.cmdPrintSetup.Name = "cmdPrintSetup"; 
            this.cmdPrintSetup.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.cmdPrintSetup.Size = new System.Drawing.Size( 65, 20 ); 
            this.cmdPrintSetup.TabIndex = 5; 
            this.cmdPrintSetup.Text = "&Setup..."; 
            // 
            // cmdPDF
            // 
            this.cmdPDF.BackColor = System.Drawing.SystemColors.Control; 
            this.cmdPDF.Cursor = System.Windows.Forms.Cursors.Default; 
            this.cmdPDF.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.cmdPDF.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.cmdPDF.Location = new System.Drawing.Point( 272, 0 ); 
            this.cmdPDF.Name = "cmdPDF"; 
            this.cmdPDF.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.cmdPDF.Size = new System.Drawing.Size( 65, 20 ); 
            this.cmdPDF.TabIndex = 4; 
            this.cmdPDF.Text = "PDF..."; 
            // 
            // cmdPrintPrev
            // 
            this.cmdPrintPrev.BackColor = System.Drawing.SystemColors.Control; 
            this.cmdPrintPrev.Cursor = System.Windows.Forms.Cursors.Default; 
            this.cmdPrintPrev.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.cmdPrintPrev.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.cmdPrintPrev.Location = new System.Drawing.Point( 136, 0 ); 
            this.cmdPrintPrev.Name = "cmdPrintPrev"; 
            this.cmdPrintPrev.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.cmdPrintPrev.Size = new System.Drawing.Size( 65, 20 ); 
            this.cmdPrintPrev.TabIndex = 3; 
            this.cmdPrintPrev.Text = "Prev Pg"; 
            // 
            // cmdPrintNext
            // 
            this.cmdPrintNext.BackColor = System.Drawing.SystemColors.Control; 
            this.cmdPrintNext.Cursor = System.Windows.Forms.Cursors.Default; 
            this.cmdPrintNext.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.cmdPrintNext.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.cmdPrintNext.Location = new System.Drawing.Point( 208, 0 ); 
            this.cmdPrintNext.Name = "cmdPrintNext"; 
            this.cmdPrintNext.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.cmdPrintNext.Size = new System.Drawing.Size( 57, 20 ); 
            this.cmdPrintNext.TabIndex = 2; 
            this.cmdPrintNext.Text = "Next Pg"; 
            // 
            // cmdPrintPrint
            // 
            this.cmdPrintPrint.BackColor = System.Drawing.SystemColors.Control; 
            this.cmdPrintPrint.Cursor = System.Windows.Forms.Cursors.Default; 
            this.cmdPrintPrint.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.cmdPrintPrint.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.cmdPrintPrint.Location = new System.Drawing.Point( 0, 0 ); 
            this.cmdPrintPrint.Name = "cmdPrintPrint"; 
            this.cmdPrintPrint.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.cmdPrintPrint.Size = new System.Drawing.Size( 65, 20 ); 
            this.cmdPrintPrint.TabIndex = 1; 
            this.cmdPrintPrint.Text = "&Print..."; 
            // 
            // TXT_unitMM
            // 
            this.TXT_unitMM.AcceptsReturn = true; 
            this.TXT_unitMM.AutoSize = false; 
            this.TXT_unitMM.BackColor = System.Drawing.SystemColors.Window; 
            this.TXT_unitMM.Cursor = System.Windows.Forms.Cursors.IBeam; 
            this.TXT_unitMM.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.TXT_unitMM.ForeColor = System.Drawing.SystemColors.WindowText; 
            this.TXT_unitMM.Location = new System.Drawing.Point( 392, 0 ); 
            this.TXT_unitMM.MaxLength = 0; 
            this.TXT_unitMM.Name = "TXT_unitMM"; 
            this.TXT_unitMM.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.TXT_unitMM.Size = new System.Drawing.Size( 49, 19 ); 
            this.TXT_unitMM.TabIndex = 0; 
            this.TXT_unitMM.Text = "0"; 
            // 
            // CommonDialog1
            // 
            this.CommonDialog1.Enabled = true; 
            this.CommonDialog1.Location = new System.Drawing.Point( 536, 360 ); 
            this.CommonDialog1.Name = "CommonDialog1"; 
            this.CommonDialog1.OcxState = ( ( System.Windows.Forms.AxHost.State )( resources.GetObject( "CommonDialog1.OcxState" ) ) ); 
            this.CommonDialog1.Size = new System.Drawing.Size( 32, 32 ); 
            this.CommonDialog1.TabIndex = 6; 
            // 
            // Label1
            // 
            this.Label1.BackColor = System.Drawing.SystemColors.Control; 
            this.Label1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D; 
            this.Label1.Cursor = System.Windows.Forms.Cursors.Default; 
            this.Label1.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.Label1.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.Label1.Location = new System.Drawing.Point( 472, 0 ); 
            this.Label1.Name = "Label1"; 
            this.Label1.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.Label1.Size = new System.Drawing.Size( 97, 17 ); 
            this.Label1.TabIndex = 8; 
            // 
            // Label2
            // 
            this.Label2.BackColor = System.Drawing.SystemColors.Control; 
            this.Label2.Cursor = System.Windows.Forms.Cursors.Default; 
            this.Label2.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.Label2.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.Label2.Location = new System.Drawing.Point( 352, 0 ); 
            this.Label2.Name = "Label2"; 
            this.Label2.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.Label2.Size = new System.Drawing.Size( 41, 17 ); 
            this.Label2.TabIndex = 7; 
            this.Label2.Text = "1 unit ="; 
            // 
            // Label3
            // 
            this.Label3.BackColor = System.Drawing.SystemColors.Control; 
            this.Label3.Cursor = System.Windows.Forms.Cursors.Default; 
            this.Label3.Font = new System.Drawing.Font( "Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.Label3.ForeColor = System.Drawing.SystemColors.ControlText; 
            this.Label3.Location = new System.Drawing.Point( 448, 0 ); 
            this.Label3.Name = "Label3"; 
            this.Label3.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.Label3.Size = new System.Drawing.Size( 25, 17 ); 
            this.Label3.TabIndex = 6; 
            this.Label3.Text = "mm"; 
            // 
            // Preview1
            // 
            this.Preview1.Enabled = true; 
            this.Preview1.Location = new System.Drawing.Point( 8, 32 ); 
            this.Preview1.Name = "Preview1"; 
            this.Preview1.OcxState = ( ( System.Windows.Forms.AxHost.State )( resources.GetObject( "Preview1.OcxState" ) ) ); 
            this.Preview1.Size = new System.Drawing.Size( 544, 333 ); 
            this.Preview1.TabIndex = 9; 
            // 
            // FrmPrintPreview
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size( 5, 13 ); 
            this.BackColor = System.Drawing.SystemColors.Control; 
            this.ClientSize = new System.Drawing.Size( 562, 348 ); 
            this.Controls.Add( this.Preview1 ); 
            this.Controls.Add( this.cmdPrintSetup ); 
            this.Controls.Add( this.cmdPDF ); 
            this.Controls.Add( this.cmdPrintPrev ); 
            this.Controls.Add( this.cmdPrintNext ); 
            this.Controls.Add( this.cmdPrintPrint ); 
            this.Controls.Add( this.TXT_unitMM ); 
            this.Controls.Add( this.CommonDialog1 ); 
            this.Controls.Add( this.Label1 ); 
            this.Controls.Add( this.Label2 ); 
            this.Controls.Add( this.Label3 ); 
            this.Cursor = System.Windows.Forms.Cursors.Default; 
            this.Font = new System.Drawing.Font( "Arial", 8.0F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, System.Convert.ToByte( 0 ) ); 
            this.KeyPreview = true; 
            this.Location = new System.Drawing.Point( 4, 23 ); 
            this.Name = "FrmPrintPreview"; 
            this.RightToLeft = System.Windows.Forms.RightToLeft.No; 
            this.Text = "AVAX Print Preview"; 
            ( ( System.ComponentModel.ISupportInitialize )( this.CommonDialog1 ) ).EndInit(); 
            ( ( System.ComponentModel.ISupportInitialize )( this.Preview1 ) ).EndInit(); 
            this.ResumeLayout( false ); 
            
            // events handled by FrmPrintPreview_KeyPress
            /* TRANSWARNING: check EventHandler assignment */ 
            base.KeyPress += new System.Windows.Forms.KeyPressEventHandler( FrmPrintPreview_KeyPress ); 
            // events handled by cmdPDF_Click
            /* TRANSWARNING: check EventHandler assignment */ 
            cmdPDF.Click += new System.EventHandler( cmdPDF_Click ); 
            // events handled by cmdPrintNext_Click
            /* TRANSWARNING: check EventHandler assignment */ 
            cmdPrintNext.Click += new System.EventHandler( cmdPrintNext_Click ); 
            // events handled by cmdPrintPrev_Click
            /* TRANSWARNING: check EventHandler assignment */ 
            cmdPrintPrev.Click += new System.EventHandler( cmdPrintPrev_Click ); 
            // events handled by cmdPrintPrint_Click
            /* TRANSWARNING: check EventHandler assignment */ 
            cmdPrintPrint.Click += new System.EventHandler( cmdPrintPrint_Click ); 
            // events handled by cmdPrintSetup_Click
            /* TRANSWARNING: check EventHandler assignment */ 
            cmdPrintSetup.Click += new System.EventHandler( cmdPrintSetup_Click ); 
            // events handled by FrmPrintPreview_Resize
            /* TRANSWARNING: check EventHandler assignment */ 
            base.Resize += new System.EventHandler( FrmPrintPreview_Resize ); 
            // events handled by TXT_unitMM_Validated
            /* TRANSWARNING: check EventHandler assignment */ 
            TXT_unitMM.Validated += new System.EventHandler( TXT_unitMM_Validated ); 
            // events handled by Preview1_PrintingPage
            /* TRANSWARNING: check EventHandler assignment */ 
            Preview1.PrintingPage += new AxavPreview.__Preview_PrintingPageEventHandler( Preview1_PrintingPage ); 
            // events handled by FrmPrintPreview_Load
            /* TRANSWARNING: check EventHandler assignment */ 
            base.Load += new System.EventHandler( FrmPrintPreview_Load ); 
        } 
        
        #endregion 
        #region '"Upgrade Support "' 
        private static FrmPrintPreview m_vb6FormDefInstance; 
        private static bool m_InitializingDefInstance; 
        public static FrmPrintPreview DefInstance 
        { 
            get 
            { 
                FrmPrintPreview defInstanceReturn = null;
                if ( m_vb6FormDefInstance == null || m_vb6FormDefInstance.IsDisposed ) 
                { 
                    m_InitializingDefInstance = true; 
                    m_vb6FormDefInstance = new FrmPrintPreview(); 
                    m_InitializingDefInstance = false; 
                } 
                defInstanceReturn = m_vb6FormDefInstance; 
                return defInstanceReturn;
            } 
            set 
            { 
                m_vb6FormDefInstance = value; 
            } 
        } 
        #endregion 
        
        private AxAvax.AxcAvax m_Avax; 
        
        private void FrmPrintPreview_KeyPress( System.Object eventSender, System.Windows.Forms.KeyPressEventArgs eventArgs ) 
        { 
            short KeyAscii = System.Convert.ToInt16(  System.Convert.ToInt32( eventArgs.KeyChar ) ); 
            if ( KeyAscii == System.Convert.ToDouble( System.Windows.Forms.Keys.Escape ) ) 
            { 
                if ( !( m_Avax == null ) ) 
                { 
                    if ( m_Avax.AbortPrinting() == true ) 
                    {
                        short param0 = 1;
                        Preview1.set_PreviewPage(ref param0); 
                        UpdatePageCount(); 
                    } 
                } 
            } 
            if ( KeyAscii == 0 ) 
            { 
                eventArgs.Handled = true; 
            } 
        } 
        
        
        private void cmdPDF_Click( System.Object eventSender, System.EventArgs eventArgs ) 
        { 
            string sPDFFile = null; 
            sPDFFile = GetPDFFile(); 
            if ( Preview1.PrintToPDF( ref sPDFFile ) == true ) 
            { 
                modAvax.ShellExecute( 0, "", sPDFFile, "", "", 1 ); 
            }
            short param0 = 1;
            Preview1.set_PreviewPage(ref param0); 
            UpdatePageCount(); 
        } 
        
        
        private void cmdPrintNext_Click( System.Object eventSender, System.EventArgs eventArgs ) 
        {
            short param0;
            if ( Preview1.CurrentPage < Preview1.MaxPage ) 
            {
                param0 = System.Convert.ToInt16(Preview1.CurrentPage + 1);
                Preview1.set_PreviewPage(ref param0); 
            } 
            UpdatePageCount(); 
        } 
        
        
        private void cmdPrintPrev_Click( System.Object eventSender, System.EventArgs eventArgs ) 
        {
            short param0;
            if ( Preview1.CurrentPage > 1 ) 
            {
                param0 = System.Convert.ToInt16(Preview1.CurrentPage - 1);
                Preview1.set_PreviewPage(ref param0); 
            } 
            UpdatePageCount(); 
        } 
        
        
        private void cmdPrintPrint_Click( System.Object eventSender, System.EventArgs eventArgs ) 
        {
            short param0 = 1;
            Preview1.PrintAVAX();
            Preview1.set_PreviewPage(ref param0); 
            UpdatePageCount(); 
        } 
        
        
        private void cmdPrintSetup_Click( System.Object eventSender, System.EventArgs eventArgs ) 
        { 
            if ( Preview1.ShowPrintDialog( avPreview.PrintDialogConstants.pdPageSetup ) ) 
            { 
                Init(); 
            } 
        } 
        
        
        private void Init() 
        { 
            bool bcmdPrintPrint = false; 
            bool bcmdPrintSetup = false; 
            bool bcmdPDF = false; 
            bool bcmdPrintNext = false; 
            bool bcmdPrintPrev = false; 
            System.Object o1 = null;
            short param0 = 1;
            string transTemp0 = TXT_unitMM.Text; 
            if (  transTemp0.Trim() != "" ) 
            { 
                Preview1.UnitMM = System.Convert.ToSingle( Conversion.Val( TXT_unitMM.Text ) ); 
            } 
            else 
            { 
                Preview1.UnitMM = 0; 
            } 
            if ( !( ( m_Avax == null ) ) ) 
            { 
                o1 = m_Avax; 
                Preview1.Setup( ref o1 ); 
                bcmdPrintPrint = cmdPrintPrint.Enabled; 
                bcmdPrintSetup = cmdPrintSetup.Enabled; 
                bcmdPDF = cmdPDF.Enabled; 
                bcmdPrintNext = cmdPrintNext.Enabled; 
                bcmdPrintPrev = cmdPrintPrev.Enabled; 
                cmdPrintPrint.Enabled = false; 
                cmdPrintSetup.Enabled = false; 
                cmdPDF.Enabled = false; 
                cmdPrintNext.Enabled = false; 
                cmdPrintPrev.Enabled = false; 
                Preview1.BuiltPages(); 
                cmdPrintPrint.Enabled = bcmdPrintPrint; 
                cmdPrintSetup.Enabled = bcmdPrintSetup; 
                cmdPDF.Enabled = bcmdPDF; 
                cmdPrintNext.Enabled = bcmdPrintNext; 
                cmdPrintPrev.Enabled = bcmdPrintPrev;
                Preview1.set_PreviewPage(ref param0); 
                UpdatePageCount(); 
                float TopHeight = 0; 
                TopHeight = System.Convert.ToSingle( Microsoft.VisualBasic.Compatibility.VB6.Support.PixelsToTwipsY( cmdPrintPrint.Height ) ); 
                Preview1.SetBounds( 0, System.Convert.ToInt32( Microsoft.VisualBasic.Compatibility.VB6.Support.TwipsToPixelsY( TopHeight + 50 ) ), this.ClientRectangle.Width, System.Convert.ToInt32( Microsoft.VisualBasic.Compatibility.VB6.Support.TwipsToPixelsY( Microsoft.VisualBasic.Compatibility.VB6.Support.PixelsToTwipsY( this.ClientRectangle.Height ) - TopHeight - 50 ) ) ); 
                Preview1.BuiltPages(); 
            } 
        } 
        
        
        public void Setup( ref AxAvax.AxcAvax oAvax ) 
        { 
            m_Avax = oAvax; 
            Init(); 
        } 
        
        
        private void FrmPrintPreview_Resize( System.Object eventSender, System.EventArgs eventArgs ) 
        { 
            float TopHeight = 0; 
            TopHeight = System.Convert.ToSingle( Microsoft.VisualBasic.Compatibility.VB6.Support.PixelsToTwipsY( cmdPrintPrint.Height ) ); 
            Preview1.SetBounds( 0, System.Convert.ToInt32( Microsoft.VisualBasic.Compatibility.VB6.Support.TwipsToPixelsY( TopHeight + 50 ) ), this.ClientRectangle.Width, System.Convert.ToInt32( Microsoft.VisualBasic.Compatibility.VB6.Support.TwipsToPixelsY( Microsoft.VisualBasic.Compatibility.VB6.Support.PixelsToTwipsY( this.ClientRectangle.Height ) - TopHeight - 50 ) ) ); 
            Init(); 
        } 
        
        
        private void UpdatePageCount() 
        { 
            Label1.Text = "Page " + Preview1.CurrentPage + " of " + Preview1.MaxPage; 
            if ( Preview1.MaxPage == 1 ) 
            { 
                cmdPrintNext.Enabled = false; 
                cmdPrintPrev.Enabled = false; 
            } 
            else 
            { 
                cmdPrintNext.Enabled = true; 
                cmdPrintPrev.Enabled = true; 
            } 
        } 
        
        
        private void TXT_unitMM_Validated( object sender, System.EventArgs e ) 
        { 
            float UnitMM = 0; 
            string sMsg = null; 
            int lMaxPg = 0; 
            UnitMM = System.Convert.ToSingle( Conversion.Val( TXT_unitMM.Text ) ); 
            if ( Preview1.UnitMM != UnitMM ) 
            { 
                lMaxPg = Preview1.CountPages( ref UnitMM ); 
                if ( lMaxPg > 30 ) 
                { 
                    sMsg = "Are you sure that you want to print" + Conversion.Str( lMaxPg ) + " pages?"; 
                    if ( Interaction.MsgBox( sMsg, ( ( Microsoft.VisualBasic.MsgBoxStyle )( System.Convert.ToInt32( MsgBoxStyle.Critical ) + System.Convert.ToInt32( MsgBoxStyle.YesNo ) ) ), "Too many pages" ) != MsgBoxResult.Yes ) 
                    { 
                        UnitMM = 0; 
                    } 
                } 
                if ( UnitMM == 0 )
                { 
                    TXT_unitMM.Text = "0"; 
                } 
                Init(); 
            } 
        } 
        
        
        public string GetPDFFile() 
        { 
            string getPDFFileReturn = null;
            string sExpFile = null; 
            string sMask = null; 
            string sExpExt = null; 
            string sFileName = null; 
            try 
            { 
                sMask = "Portable Document Format (*.PDF)|*.PDF|"; 
                AxMSComDlg.AxCommonDialog transTemp1 = CommonDialog1;
                transTemp1.FileName = ""; 
                transTemp1.CancelError = true; 
                try 
                { 
                    transTemp1.DialogTitle = "Export to PDF..."; 
                    transTemp1.Filter = sMask; 
                    transTemp1.Flags = System.Convert.ToInt32( MSComDlg.FileOpenConstants.cdlOFNOverwritePrompt ); 
                    transTemp1.ShowSave(); 
                    sFileName = transTemp1.FileName; 
                } 
                catch  
                { 
                    goto Lab_Error; 
                } 
                
                sExpFile = sFileName; 
                if ( sExpFile != "" )
                { 
                    getPDFFileReturn = sExpFile; 
                } 
                return getPDFFileReturn; 
            } 
            catch  
            { 
                goto Lab_Error; 
            } 
            Lab_Error: 
            
            return getPDFFileReturn;
        } 
        
        
        public bool ExportToPDF( ref AxAvax.AxcAvax oAvax, ref string sPDFFile ) 
        { 
            bool exportToPDFReturn = false;
            m_Avax = oAvax; 
            Init(); 
            if ( Preview1.PrintToPDF( ref sPDFFile ) == true ) 
            { 
                modAvax.ShellExecute( 0, "", sPDFFile, "", "", 1 ); 
                exportToPDFReturn = true; 
            } 
            return exportToPDFReturn;
        } 
        
        
        private void Preview1_PrintingPage( object sender, AxavPreview.__Preview_PrintingPageEvent e ) 
        { 
            Label1.Text = "Page " + e.lNowPage + " of " + e.lMaxPage; 
            if ( e.lNowPage <= Preview1.MaxPage ) 
            {
                short param0 = System.Convert.ToInt16(e.lNowPage);
                Preview1.set_PreviewPage(ref param0); 
            } 
        } 
        
        
        private void FrmPrintPreview_Load( System.Object sender, System.EventArgs e ) 
        { 
            
        } 
        
        /* TRANSINFO: Default instance for Form */
        private static FrmPrintPreview transDefaultFormFrmPrintPreview = null;
        public static FrmPrintPreview TransDefaultFormFrmPrintPreview
        { 
        	get
        	{ 
        		if (transDefaultFormFrmPrintPreview == null)
        		{
        			transDefaultFormFrmPrintPreview = new FrmPrintPreview();
        		}
        		return transDefaultFormFrmPrintPreview;
        	} 
        } 
    } 
    
} 
