using Microsoft.VisualBasic;
using Microsoft.VisualBasic.Compatibility;
using System;
using System.Collections;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
namespace AvaxCAD
{
    [Microsoft.VisualBasic.CompilerServices.StandardModule]
    static public class modAvax 
    { 
        
        [System.Runtime.InteropServices.DllImport("shell32.dll",EntryPoint = "ShellExecuteA")]
        public static extern int ShellExecute( int hwnd, string lpOperation, string lpFile, string lpParameters, string lpDirectory, int nShowCmd ); 
        
        [System.Runtime.InteropServices.DllImport("user32",EntryPoint = "WinHelpA")]
        public static extern int WinHelp( int hwnd, string lpHelpFile, int wCommand, int dwData ); 
        
        private const int SW_SHOWNORMAL = 1; 
        public const int HELP_CONTENTS = 0X3; 
        
        public static void SendMail( [System.Runtime.InteropServices.Optional] ref string Address, [System.Runtime.InteropServices.Optional] ref string Subject, [System.Runtime.InteropServices.Optional] ref string Body, [System.Runtime.InteropServices.Optional] ref string cc, [System.Runtime.InteropServices.Optional] ref string 
        BCC, [System.Runtime.InteropServices.Optional] ref int hwnd) 
        { 
            string strCommand = null; 
            if (Subject.Length != 0)
            { 
                strCommand = "&Subject=" + Subject; 
            } 
            if (Body.Length != 0)
            { 
                strCommand = strCommand + "&Body=" + Body; 
            } 
            if (cc.Length != 0)
            { 
                strCommand = strCommand + "&CC=" + cc; 
            } 
            if (BCC.Length != 0)
            { 
                strCommand = strCommand + "&BCC=" + BCC; 
            } 
            strCommand = "mailto:" + Address + strCommand; 
            ShellExecute( hwnd, "open", strCommand, "", "", SW_SHOWNORMAL ); 
        } 
        
        
        public static bool AskForSaveFile( string sFile, ref short Cancel ) 
        { 
            bool askForSaveFileReturn = false;
            string sMsg = null; 
            short iAns = 0; 
            sMsg = "Do you want to save the current drawing?"; 
            if ( sFile == "" )
            { 
                sFile = "Untitle drawing..."; 
            } 
            iAns = System.Convert.ToInt16( Interaction.MsgBox( sMsg, ( ( Microsoft.VisualBasic.MsgBoxStyle )( System.Convert.ToInt32( MsgBoxStyle.Exclamation ) + System.Convert.ToInt32( MsgBoxStyle.YesNoCancel ) ) ), sFile ) ); 
            switch ( iAns ) 
            {
                case (System.Int16)MsgBoxResult.No:
                    Cancel = 0; 
                    break;
                case (System.Int16)MsgBoxResult.Yes:
                    askForSaveFileReturn = true; 
                    Cancel = 0; 
                    break;
                case (System.Int16)MsgBoxResult.Cancel:
                    Cancel = 1; 
                    break;
            }
            
            return askForSaveFileReturn;
        } 
        
        
        public static void swap( ref object a, ref object b ) 
        { 
            
            object c = null; 
            c = b; 
            b = a; 
            a = c; 
            
        } 
        
        
        public static bool IsFile( ref string sFile ) 
        { 
            bool isFileReturn = false;
            int lLen = 0; 
            try 
            { 
                if ( sFile == "" )
                { 
                    return isFileReturn; 
                } 
                lLen = System.Convert.ToInt32( FileSystem.FileLen( sFile ) ); 
                isFileReturn = true; 
                return isFileReturn; 
            } 
            catch  
            { 
                goto Lab_Error; 
            } 
            Lab_Error: 
            
            isFileReturn = false; 
            return isFileReturn;
        } 
        
    } 
    
} 
