// MFCAvaxView.cpp : implementation of the CMFCAvaxView class
//

#include "stdafx.h"
#include "MFCAvax.h"

#include "MFCAvaxDoc.h"
#include "MFCAvaxView.h"
#include ".\mfcavaxview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CMFCAvaxView

IMPLEMENT_DYNCREATE(CMFCAvaxView, CFormView)

BEGIN_MESSAGE_MAP(CMFCAvaxView, CFormView)
    ON_BN_CLICKED(IDC_BTN_LINE, OnBnClickedBtnLine)
    ON_BN_CLICKED(IDC_BTN_CIRCLE, OnBnClickedBtnCircle)
    ON_BN_CLICKED(IDC_BTN_DXF, OnBnClickedBtnDxf)
END_MESSAGE_MAP()

// CMFCAvaxView construction/destruction

CMFCAvaxView::CMFCAvaxView()
	: CFormView(CMFCAvaxView::IDD)
{
	// TODO: add construction code here

}

CMFCAvaxView::~CMFCAvaxView()
{
}

void CMFCAvaxView::DoDataExchange(CDataExchange* pDX)
{
    CFormView::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_CAVAX1, m_cAvax);
}

BOOL CMFCAvaxView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CMFCAvaxView::OnInitialUpdate()
{
    CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	CComBSTR bstr2(0, L"");
	m_cAvax.StartAvax(&bstr2);
}


// CMFCAvaxView diagnostics

#ifdef _DEBUG
void CMFCAvaxView::AssertValid() const
{
	CFormView::AssertValid();
}

void CMFCAvaxView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CMFCAvaxDoc* CMFCAvaxView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMFCAvaxDoc)));
	return (CMFCAvaxDoc*)m_pDocument;
}
#endif //_DEBUG


// CMFCAvaxView message handlers

void CMFCAvaxView::OnBnClickedBtnLine()
{
	short iClr=0;
	short iWidth=1;
	short iStyle=1;
	short iLayer=0;
	VARIANT v;
	v.vt = VT_BSTR | VT_SAFEARRAY;
    float x1 = 0.0;
    float y1 = 0.0;
    float z1 = 0.0;
    float x2 = 10.0;
    float y2 = 10.0;
    float z2 = 0.0;
	m_cAvax.Add_Line(&x1, &y1, &z1, &x2, &y2, &z2, &v, &iClr, &iWidth, &iStyle, &iLayer);
}

void CMFCAvaxView::OnBnClickedBtnCircle()
{
	m_cAvax.put_Command(103);
}

void CMFCAvaxView::OnBnClickedBtnDxf()
{
	short iClr=0;
	short iWidth=1;
	short iStyle=0;
	short iLayer=0;
    float x = 0.0;
    float y = 0.0;
    float z = 0.0;
	BOOL fNoText = FALSE;
	BOOL fNoBlock = FALSE;
	BOOL fNoDimension = FALSE;
	VARIANT v;
	VARIANT v1;
	SAFEARRAY *parray1;
    long lLb;

	v.vt = VT_BSTR | VT_SAFEARRAY;
	v1.vt = VT_INT | VT_SAFEARRAY;
    CComBSTR bstr(10, L".\\test.dxf");
    CComBSTR bstr2(0, L"");
	if (m_cAvax.Add_DXF(&bstr, &bstr2, &x, &y, &z, &v, &fNoText, &fNoBlock, &fNoDimension, &v1)) {
		parray1 = v1.parray;
		if (parray1 != NULL){ // array has been initialized
		SafeArrayGetUBound(parray1, 1, &lLb); 
		}
	}
	
}
