using Microsoft.VisualBasic;
using System.Data;
using Microsoft.VisualBasic.Compatibility;
using System;
using System.Collections;
using System.Windows.Forms;
using System.Diagnostics;
using AxAvax;
using System.Drawing;

namespace Clock
{
	internal class FrmClock : System.Windows.Forms.Form
	{
		[STAThread]
		static void Main()
		{
			Application.Run(new FrmClock());
		}
		#region "Windows Form Designer generated code "
		public FrmClock() {
			if (m_vb6FormDefInstance == null)
			{
				if (m_InitializingDefInstance)
				{
					m_vb6FormDefInstance = this;
				}
				else
				{
					try
					{
						//For the start-up form, the first instance created is the default instance.
						if (System.Reflection.Assembly.GetExecutingAssembly().EntryPoint.DeclaringType == this.GetType())
						{
							m_vb6FormDefInstance = this;
						}
					}
					catch
					{
					}
				}
			}
			//This call is required by the Windows Form Designer.
			InitializeComponent();
		}
		//Form overrides dispose to clean up the component list.
		protected override void Dispose (bool Disposing)
		{
			if (Disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(Disposing);
		}

		private System.ComponentModel.IContainer components;
		public System.Windows.Forms.ToolTip ToolTip1;
		public System.Windows.Forms.Timer Timer1;
		public AxAvax.AxcAvax cAvax1;
		public System.Windows.Forms.Label Label1;
//NOTE: The following procedure is required by the Windows Form Designer
		//It can be modified using the Windows Form Designer.
		//Do not modify it using the code editor.
		[System.Diagnostics.DebuggerStepThrough()]private void InitializeComponent ()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmClock));
			this.ToolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.Timer1 = new System.Windows.Forms.Timer(this.components);
			this.cAvax1 = new AxAvax.AxcAvax();
			this.Label1 = new System.Windows.Forms.Label();
			((System.ComponentModel.ISupportInitialize)(this.cAvax1)).BeginInit();
			this.SuspendLayout();
			// 
			// Timer1
			// 
			this.Timer1.Enabled = true;
			this.Timer1.Interval = 1000;
			this.Timer1.Tick += new System.EventHandler(this.Timer1_Tick);
			// 
			// cAvax1
			// 
			this.cAvax1.Enabled = true;
			this.cAvax1.Location = new System.Drawing.Point(16, 16);
			this.cAvax1.Name = "cAvax1";
			this.cAvax1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("cAvax1.OcxState")));
			this.cAvax1.Size = new System.Drawing.Size(281, 225);
			this.cAvax1.TabIndex = 0;
			// 
			// Label1
			// 
			this.Label1.BackColor = System.Drawing.SystemColors.Control;
			this.Label1.Cursor = System.Windows.Forms.Cursors.Default;
			this.Label1.Font = new System.Drawing.Font("Arial", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(161)));
			this.Label1.ForeColor = System.Drawing.SystemColors.ControlText;
			this.Label1.Location = new System.Drawing.Point(24, 256);
			this.Label1.Name = "Label1";
			this.Label1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Label1.Size = new System.Drawing.Size(105, 17);
			this.Label1.TabIndex = 1;
			// 
			// FrmClock
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.ClientSize = new System.Drawing.Size(317, 293);
			this.Controls.Add(this.cAvax1);
			this.Controls.Add(this.Label1);
			this.Cursor = System.Windows.Forms.Cursors.Default;
			this.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Location = new System.Drawing.Point(4, 23);
			this.Name = "FrmClock";
			this.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Text = "Clock";
			this.Load += new System.EventHandler(this.FrmClock_Load);
			((System.ComponentModel.ISupportInitialize)(this.cAvax1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion
		#region "Upgrade Support "
		private static FrmClock m_vb6FormDefInstance;
		private static bool m_InitializingDefInstance;
		public static FrmClock DefInstance
		{
			get{
				FrmClock returnValue;
				if (m_vb6FormDefInstance == null || m_vb6FormDefInstance.IsDisposed)
				{
					m_InitializingDefInstance = true;
					m_vb6FormDefInstance = new FrmClock();
					m_InitializingDefInstance = false;
				}
				returnValue = m_vb6FormDefInstance;
				return returnValue;
			}
			set
			{
				m_vb6FormDefInstance = value;
			}
		}
		#endregion
		
		float xC;
		float yC;
		float R;
		int lHandleHour=0;
		int lHandleMinute=0;
		int lHandleSecond=0;
		float lOldHour;
		float lOldMinute;
		float lOldSecond;
		
		private float FnCos(ref float a)
		{
			float returnValue;
			returnValue = (float) (System.Math.Cos(a * 0.017453292519943f));
			return returnValue;
		}
		
		private float FnSin(ref float a)
		{
			float returnValue;
			returnValue = (float) (System.Math.Sin(a * 0.017453292519943f));
			return returnValue;
		}
		
		private void Timer1_Tick (System.Object eventSender, System.EventArgs eventArgs)
		{
			float lHour;
			float lMinute;
			float lSecond;
			float x1;
			float y1;
			int[] h = new int[2];
			short iClr;
			short iWidth;
			short iLayer=0;
			short iStyle=0;
			int zOrder;
			object sProp;
			string[] sStr = new string[0];
			sProp=sStr;
			System.Array avHandles;
			AxAvax.AxcAvax AvaxCtrl = cAvax1;
			AvaxCtrl.AutoRedraw = false;
			lHour = (DateAndTime.Hour(DateAndTime.TimeOfDay) % 12f) * 30f;
			if (lOldHour != lHour)
			{
				x1 = xC + FnSin(ref lHour) * 0.6f * R;
				y1 = yC + FnCos(ref lHour) * 0.6f * R;
				h[1]  = lHandleHour;
				avHandles=h;
				AvaxCtrl.DeleteItems(ref avHandles);
				iClr=3;
				iWidth=5;
				zOrder=1;
				lHandleHour = AvaxCtrl.Add_ShapeLine(ref xC, ref yC,ref x1,ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
				lOldHour = lHour;
			}
			lMinute = DateAndTime.Minute(DateAndTime.TimeOfDay) * 6;
			if (lOldMinute != lMinute)
			{
				x1 = xC + FnSin(ref lMinute) * 0.75f * R;
				y1 = yC + FnCos(ref lMinute) * 0.75f * R;
				h[1] = lHandleMinute;
				avHandles=h;
				AvaxCtrl.DeleteItems(ref avHandles);
				iClr=2;
				iWidth=3;
				zOrder=2;
				lHandleMinute = AvaxCtrl.Add_ShapeLine(ref xC, ref yC, ref x1, ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
				lOldMinute = lMinute;
			}
			lSecond = DateAndTime.Second(DateAndTime.TimeOfDay) * 6;
			if (lOldSecond != lSecond)
			{
				x1 = xC + FnSin(ref lSecond) * 0.9f * R;
				y1 = yC + FnCos(ref lSecond) * 0.9f * R;
				h[1] = lHandleSecond;
				avHandles=h;
				AvaxCtrl.DeleteItems(ref avHandles);
				iClr=1;
				iWidth=4;
				zOrder=3;
				lHandleSecond = AvaxCtrl.Add_ShapeLine(ref xC, ref yC, ref x1, ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
				lOldSecond = lSecond;
			}
			AvaxCtrl.AutoRedraw = true;
			Label1.Text = DateAndTime.Now.ToString();
		}

		private void FrmClock_Load (System.Object eventSender, System.EventArgs eventArgs)
		{
			float xMin=0f;
			float yMin=0f;
			float xMax=0f;
			float yMax=0f;
			float lHour;
			float lMinute;
			float lSecond;
			float x1;
			float y1;
			float s1;
			float p1;
			object pfile;
			string str;
			Avax.AvaxProp prop;
			object f;
			short iClr;
			short iWidth;
			short iLayer=0;
			short iStyle=0;
			int zOrder;
			int h1;
			object sProp;
			string[] sStr = new string[0];
			sProp=sStr;
			AxAvax.AxcAvax AvaxCtrl = cAvax1;
			pfile=Microsoft.VisualBasic.Compatibility.VB6.Support.GetPath() + "\\tile.bmp";
			prop=Avax.AvaxProp.TilePictureFile_p;
			AvaxCtrl.SetAvaxProperty(ref prop,  ref pfile);
			AvaxCtrl.LockEdit = true;
			prop=Avax.AvaxProp.SelectCursorHideOn_p;
			f=true;
			AvaxCtrl.SetAvaxProperty(ref prop, ref f);
			str="";
			AvaxCtrl.StartAvax(ref str);
			AvaxCtrl.PauseAvaxEvents = true;
			AvaxCtrl.GetBoundsZoom(ref xMin,ref yMin,ref xMax,ref yMax);
			xC = xMin +(xMax - xMin) / 2;
			yC = yMin +(yMax - yMin) / 2;
			if ((yMax - yMin) / 2 <(xMax - xMin) / 2)
			{
				R = 0.8f *(yMax - yMin) / 2f;
			}
			else
			{
				R = 0.8f *(xMax - xMin) / 2f;
			}
			iClr=3;
			iWidth=5;
			zOrder=1;
			str="";
			x1=R / 12;
			byte filltype=1;
			int fillHatchIndex=2;
			short fillForeColor=1;
			short fillBackColor=5;
			int fillFlags=0;
			zOrder=10;
			int nVert=12;
			AvaxCtrl.Add_ShapeRegularPolygon(ref xC, ref yC, ref x1, ref nVert,ref sProp, ref filltype, ref fillHatchIndex, ref fillForeColor, ref fillBackColor,ref str, ref zOrder,ref fillFlags,ref iClr,ref iWidth, ref iStyle, ref iLayer);
			for (s1 = 0; s1 <= 11; s1++)
			{
				p1 = s1 * 30f;
				x1 = xC + FnSin(ref p1) * R;
				y1 = yC + FnCos(ref p1) * R;
				iClr=1;
				iWidth=5;
				short pointstyle=0;
				h1 = AvaxCtrl.Add_ShapePoint(ref x1, ref y1,ref sProp,ref iClr,ref iWidth,ref pointstyle,ref iLayer, ref zOrder);
			}
			lHour = (DateAndTime.Hour(DateAndTime.TimeOfDay) % 12) * 30;
			x1 = xC + FnSin(ref lHour) * 0.6f * R;
			y1 = yC + FnCos(ref lHour) * 0.6f * R;
			iClr=3;
			iWidth=5;
			zOrder=1;
			lHandleHour = AvaxCtrl.Add_ShapeLine(ref xC, ref yC, ref x1, ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
			lMinute = DateAndTime.Minute(DateAndTime.TimeOfDay) * 6;
			x1 = xC + FnSin(ref lMinute) * 0.75f * R;
			y1 = yC + FnCos(ref lMinute) * 0.75f * R;
			iClr=2;
			iWidth=3;
			zOrder=2;
			lHandleMinute = AvaxCtrl.Add_ShapeLine(ref xC, ref yC, ref x1, ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
			lSecond = DateAndTime.Second(DateAndTime.TimeOfDay) * 6;
			x1 = xC + FnSin(ref lSecond) * 0.9f * R;
			y1 = yC + FnCos(ref lSecond) * 0.9f * R;
			iClr=1;
			iWidth=4;
			zOrder=3;
			lHandleSecond = AvaxCtrl.Add_ShapeLine(ref xC, ref yC, ref x1, ref y1,ref sProp,ref iClr,ref iWidth, ref iStyle, ref iLayer, ref zOrder);
			lOldHour = lHour;
			lOldMinute = lMinute;
			lOldSecond = lSecond;
		}
	}
}
