Option Strict Off
Option Explicit On
Friend Class FrmPrintPreview
	Inherits System.Windows.Forms.Form
#Region "Windows Form Designer generated code "
	Public Sub New()
        MyBase.New()
        If m_vb6FormDefInstance Is Nothing Then
            If m_InitializingDefInstance Then
                m_vb6FormDefInstance = Me
            Else
                Try
                    'For the start-up form, the first instance created is the default instance.
                    If System.Reflection.Assembly.GetExecutingAssembly.EntryPoint.DeclaringType Is Me.GetType Then
                        m_vb6FormDefInstance = Me
                    End If
                Catch
                End Try
            End If
        End If
        'This call is required by the Windows Form Designer.
        InitializeComponent()

	End Sub
	'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal Disposing As Boolean)
        Call Preview1.Terminate()
        If Disposing Then
            Static fTerminateCalled As Boolean
            If Not fTerminateCalled Then
                fTerminateCalled = True
            End If
            If Not components Is Nothing Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(Disposing)
    End Sub
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer
    Public ToolTip1 As System.Windows.Forms.ToolTip
    Public WithEvents cmdPrintSetup As System.Windows.Forms.Button
    Public WithEvents cmdPDF As System.Windows.Forms.Button
    Public WithEvents cmdPrintPrev As System.Windows.Forms.Button
    Public WithEvents cmdPrintNext As System.Windows.Forms.Button
    Public WithEvents cmdPrintPrint As System.Windows.Forms.Button
    Public WithEvents TXT_unitMM As System.Windows.Forms.TextBox
    Public WithEvents CommonDialog1 As AxMSComDlg.AxCommonDialog
    Public WithEvents Label1 As System.Windows.Forms.Label
    Public WithEvents Label2 As System.Windows.Forms.Label
    Public WithEvents Label3 As System.Windows.Forms.Label
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.
    'Do not modify it using the code editor.
    Friend WithEvents Preview1 As AxavPreview.AxPreview
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(FrmPrintPreview))
        Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
        Me.cmdPrintSetup = New System.Windows.Forms.Button
        Me.cmdPDF = New System.Windows.Forms.Button
        Me.cmdPrintPrev = New System.Windows.Forms.Button
        Me.cmdPrintNext = New System.Windows.Forms.Button
        Me.cmdPrintPrint = New System.Windows.Forms.Button
        Me.TXT_unitMM = New System.Windows.Forms.TextBox
        Me.CommonDialog1 = New AxMSComDlg.AxCommonDialog
        Me.Label1 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.Preview1 = New AxavPreview.AxPreview
        CType(Me.CommonDialog1, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.Preview1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'cmdPrintSetup
        '
        Me.cmdPrintSetup.BackColor = System.Drawing.SystemColors.Control
        Me.cmdPrintSetup.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdPrintSetup.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdPrintSetup.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdPrintSetup.Location = New System.Drawing.Point(69, 0)
        Me.cmdPrintSetup.Name = "cmdPrintSetup"
        Me.cmdPrintSetup.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdPrintSetup.Size = New System.Drawing.Size(65, 20)
        Me.cmdPrintSetup.TabIndex = 5
        Me.cmdPrintSetup.Text = "&Setup..."
        '
        'cmdPDF
        '
        Me.cmdPDF.BackColor = System.Drawing.SystemColors.Control
        Me.cmdPDF.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdPDF.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdPDF.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdPDF.Location = New System.Drawing.Point(272, 0)
        Me.cmdPDF.Name = "cmdPDF"
        Me.cmdPDF.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdPDF.Size = New System.Drawing.Size(65, 20)
        Me.cmdPDF.TabIndex = 4
        Me.cmdPDF.Text = "PDF..."
        '
        'cmdPrintPrev
        '
        Me.cmdPrintPrev.BackColor = System.Drawing.SystemColors.Control
        Me.cmdPrintPrev.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdPrintPrev.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdPrintPrev.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdPrintPrev.Location = New System.Drawing.Point(136, 0)
        Me.cmdPrintPrev.Name = "cmdPrintPrev"
        Me.cmdPrintPrev.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdPrintPrev.Size = New System.Drawing.Size(65, 20)
        Me.cmdPrintPrev.TabIndex = 3
        Me.cmdPrintPrev.Text = "Prev Pg"
        '
        'cmdPrintNext
        '
        Me.cmdPrintNext.BackColor = System.Drawing.SystemColors.Control
        Me.cmdPrintNext.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdPrintNext.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdPrintNext.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdPrintNext.Location = New System.Drawing.Point(208, 0)
        Me.cmdPrintNext.Name = "cmdPrintNext"
        Me.cmdPrintNext.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdPrintNext.Size = New System.Drawing.Size(57, 20)
        Me.cmdPrintNext.TabIndex = 2
        Me.cmdPrintNext.Text = "Next Pg"
        '
        'cmdPrintPrint
        '
        Me.cmdPrintPrint.BackColor = System.Drawing.SystemColors.Control
        Me.cmdPrintPrint.Cursor = System.Windows.Forms.Cursors.Default
        Me.cmdPrintPrint.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.cmdPrintPrint.ForeColor = System.Drawing.SystemColors.ControlText
        Me.cmdPrintPrint.Location = New System.Drawing.Point(0, 0)
        Me.cmdPrintPrint.Name = "cmdPrintPrint"
        Me.cmdPrintPrint.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.cmdPrintPrint.Size = New System.Drawing.Size(65, 20)
        Me.cmdPrintPrint.TabIndex = 1
        Me.cmdPrintPrint.Text = "&Print..."
        '
        'TXT_unitMM
        '
        Me.TXT_unitMM.AcceptsReturn = True
        Me.TXT_unitMM.AutoSize = False
        Me.TXT_unitMM.BackColor = System.Drawing.SystemColors.Window
        Me.TXT_unitMM.Cursor = System.Windows.Forms.Cursors.IBeam
        Me.TXT_unitMM.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.TXT_unitMM.ForeColor = System.Drawing.SystemColors.WindowText
        Me.TXT_unitMM.Location = New System.Drawing.Point(392, 0)
        Me.TXT_unitMM.MaxLength = 0
        Me.TXT_unitMM.Name = "TXT_unitMM"
        Me.TXT_unitMM.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.TXT_unitMM.Size = New System.Drawing.Size(49, 19)
        Me.TXT_unitMM.TabIndex = 0
        Me.TXT_unitMM.Text = "0"
        '
        'CommonDialog1
        '
        Me.CommonDialog1.Enabled = True
        Me.CommonDialog1.Location = New System.Drawing.Point(536, 360)
        Me.CommonDialog1.Name = "CommonDialog1"
        Me.CommonDialog1.OcxState = CType(resources.GetObject("CommonDialog1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.CommonDialog1.Size = New System.Drawing.Size(32, 32)
        Me.CommonDialog1.TabIndex = 6
        '
        'Label1
        '
        Me.Label1.BackColor = System.Drawing.SystemColors.Control
        Me.Label1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Label1.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label1.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label1.Location = New System.Drawing.Point(472, 0)
        Me.Label1.Name = "Label1"
        Me.Label1.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label1.Size = New System.Drawing.Size(97, 17)
        Me.Label1.TabIndex = 8
        '
        'Label2
        '
        Me.Label2.BackColor = System.Drawing.SystemColors.Control
        Me.Label2.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label2.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label2.Location = New System.Drawing.Point(352, 0)
        Me.Label2.Name = "Label2"
        Me.Label2.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label2.Size = New System.Drawing.Size(41, 17)
        Me.Label2.TabIndex = 7
        Me.Label2.Text = "1 unit ="
        '
        'Label3
        '
        Me.Label3.BackColor = System.Drawing.SystemColors.Control
        Me.Label3.Cursor = System.Windows.Forms.Cursors.Default
        Me.Label3.Font = New System.Drawing.Font("Arial", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label3.ForeColor = System.Drawing.SystemColors.ControlText
        Me.Label3.Location = New System.Drawing.Point(448, 0)
        Me.Label3.Name = "Label3"
        Me.Label3.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Label3.Size = New System.Drawing.Size(25, 17)
        Me.Label3.TabIndex = 6
        Me.Label3.Text = "mm"
        '
        'Preview1
        '
        Me.Preview1.Enabled = True
        Me.Preview1.Location = New System.Drawing.Point(8, 32)
        Me.Preview1.Name = "Preview1"
        Me.Preview1.OcxState = CType(resources.GetObject("Preview1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.Preview1.Size = New System.Drawing.Size(544, 333)
        Me.Preview1.TabIndex = 9
        '
        'FrmPrintPreview
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BackColor = System.Drawing.SystemColors.Control
        Me.ClientSize = New System.Drawing.Size(562, 348)
        Me.Controls.Add(Me.Preview1)
        Me.Controls.Add(Me.cmdPrintSetup)
        Me.Controls.Add(Me.cmdPDF)
        Me.Controls.Add(Me.cmdPrintPrev)
        Me.Controls.Add(Me.cmdPrintNext)
        Me.Controls.Add(Me.cmdPrintPrint)
        Me.Controls.Add(Me.TXT_unitMM)
        Me.Controls.Add(Me.CommonDialog1)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.Label3)
        Me.Cursor = System.Windows.Forms.Cursors.Default
        Me.Font = New System.Drawing.Font("Arial", 8.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.KeyPreview = True
        Me.Location = New System.Drawing.Point(4, 23)
        Me.Name = "FrmPrintPreview"
        Me.RightToLeft = System.Windows.Forms.RightToLeft.No
        Me.Text = "AVAX Print Preview"
        CType(Me.CommonDialog1, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.Preview1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub
#End Region 
#Region "Upgrade Support "
	Private Shared m_vb6FormDefInstance As FrmPrintPreview
	Private Shared m_InitializingDefInstance As Boolean
	Public Shared Property DefInstance() As FrmPrintPreview
		Get
			If m_vb6FormDefInstance Is Nothing OrElse m_vb6FormDefInstance.IsDisposed Then
				m_InitializingDefInstance = True
				m_vb6FormDefInstance = New FrmPrintPreview()
				m_InitializingDefInstance = False
			End If
			DefInstance = m_vb6FormDefInstance
		End Get
		Set
			m_vb6FormDefInstance = Value
		End Set
	End Property
#End Region 
	
    Private m_Avax As AxAvax.AxcAvax
	
	Private Sub FrmPrintPreview_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles MyBase.KeyPress
		Dim KeyAscii As Short = Asc(eventArgs.KeyChar)
		If KeyAscii = System.Windows.Forms.Keys.Escape Then
			If Not m_Avax Is Nothing Then
				If m_Avax.AbortPrinting = True Then
					Preview1.set_PreviewPage(1)
					Call UpdatePageCount()
				End If
			End If
		End If
		If KeyAscii = 0 Then
			eventArgs.Handled = True
		End If
	End Sub

    Private Sub cmdPDF_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPDF.Click
        Dim sPDFFile As String
        sPDFFile = GetPDFFile()
        If Preview1.PrintToPDF(sPDFFile) = True Then
            ShellExecute(0, vbNullString, sPDFFile, vbNullString, vbNullString, 1)
        End If
        Preview1.set_PreviewPage(1)
        Call UpdatePageCount()
    End Sub

    Private Sub cmdPrintNext_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintNext.Click
        If Preview1.CurrentPage < Preview1.MaxPage Then
            Preview1.set_PreviewPage(Preview1.CurrentPage + 1)
        End If
        Call UpdatePageCount()
    End Sub

    Private Sub cmdPrintPrev_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintPrev.Click
        If Preview1.CurrentPage > 1 Then
            Preview1.set_PreviewPage(Preview1.CurrentPage - 1)
        End If
        Call UpdatePageCount()
    End Sub

    Private Sub cmdPrintPrint_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintPrint.Click
        Call Preview1.PrintAVAX()
        Preview1.set_PreviewPage(1)
        Call UpdatePageCount()
    End Sub

    Private Sub cmdPrintSetup_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdPrintSetup.Click
        If Preview1.ShowPrintDialog(avPreview.PrintDialogConstants.pdPageSetup) Then
            Call Init()
        End If
    End Sub

    Private Sub Init()
        Dim bcmdPrintPrint As Boolean
        Dim bcmdPrintSetup As Boolean
        Dim bcmdPDF As Boolean
        Dim bcmdPrintNext As Boolean
        Dim bcmdPrintPrev As Boolean
        Dim o1 As System.Object
        If Trim(TXT_unitMM.Text) <> "" Then
            Preview1.UnitMM = Val(TXT_unitMM.Text)
        Else
            Preview1.UnitMM = 0
        End If
        If Not (m_Avax Is Nothing) Then
            o1 = m_Avax
            Call Preview1.Setup(o1)
            bcmdPrintPrint = cmdPrintPrint.Enabled
            bcmdPrintSetup = cmdPrintSetup.Enabled
            bcmdPDF = cmdPDF.Enabled
            bcmdPrintNext = cmdPrintNext.Enabled
            bcmdPrintPrev = cmdPrintPrev.Enabled
            cmdPrintPrint.Enabled = False
            cmdPrintSetup.Enabled = False
            cmdPDF.Enabled = False
            cmdPrintNext.Enabled = False
            cmdPrintPrev.Enabled = False
            Call Preview1.BuiltPages()
            cmdPrintPrint.Enabled = bcmdPrintPrint
            cmdPrintSetup.Enabled = bcmdPrintSetup
            cmdPDF.Enabled = bcmdPDF
            cmdPrintNext.Enabled = bcmdPrintNext
            cmdPrintPrev.Enabled = bcmdPrintPrev
            Preview1.set_PreviewPage(1)
            Call UpdatePageCount()
            On Error Resume Next
            Dim TopHeight As Single
            TopHeight = VB6.PixelsToTwipsY(cmdPrintPrint.Height)
            Call Preview1.SetBounds(0, VB6.TwipsToPixelsY(TopHeight + 50), Me.ClientRectangle.Width, VB6.TwipsToPixelsY(VB6.PixelsToTwipsY(Me.ClientRectangle.Height) - TopHeight - 50))
            Call Preview1.BuiltPages()
        End If
    End Sub

    Public Sub Setup(ByRef oAvax As AxAvax.AxcAvax)
        m_Avax = oAvax
        Call Init()
    End Sub

    Private Sub FrmPrintPreview_Resize(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Resize
        On Error Resume Next
        Dim TopHeight As Single
        TopHeight = VB6.PixelsToTwipsY(cmdPrintPrint.Height)
        Call Preview1.SetBounds(0, VB6.TwipsToPixelsY(TopHeight + 50), Me.ClientRectangle.Width, VB6.TwipsToPixelsY(VB6.PixelsToTwipsY(Me.ClientRectangle.Height) - TopHeight - 50))
        Call Init()
    End Sub

    Private Sub UpdatePageCount()
        On Error Resume Next
        Label1.Text = "Page " & Preview1.CurrentPage & " of " & Preview1.MaxPage
        If Preview1.MaxPage = 1 Then
            cmdPrintNext.Enabled = False
            cmdPrintPrev.Enabled = False
        Else
            cmdPrintNext.Enabled = True
            cmdPrintPrev.Enabled = True
        End If
    End Sub

    Private Sub TXT_unitMM_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles TXT_unitMM.Validated
        Dim UnitMM As Single
        Dim sMsg As String
        Dim lMaxPg As Integer
        UnitMM = Val(TXT_unitMM.Text)
        If Preview1.UnitMM <> UnitMM Then
            lMaxPg = Preview1.CountPages(UnitMM)
            If lMaxPg > 30 Then
                sMsg = "Are you sure that you want to print" & Str(lMaxPg) & " pages?"
                If MsgBox(sMsg, MsgBoxStyle.Critical + MsgBoxStyle.YesNo, "Too many pages") <> MsgBoxResult.Yes Then
                    UnitMM = 0
                End If
            End If
            If UnitMM = 0 Then TXT_unitMM.Text = "0"
            Call Init()
        End If
    End Sub

    Function GetPDFFile() As String
        Dim sExpFile As String
        Dim sMask As String
        Dim sExpExt As String
        Dim sFileName As String
        On Error GoTo Lab_Error
        sMask = "Portable Document Format (*.PDF)|*.PDF|"
        With CommonDialog1
            .FileName = ""
            .CancelError = True
            On Error GoTo Lab_Error
            .DialogTitle = "Export to PDF..."
            .Filter = sMask
            .Flags = MSComDlg.FileOpenConstants.cdlOFNOverwritePrompt
            .ShowSave()
            sFileName = .FileName
        End With
        sExpFile = sFileName
        If sExpFile <> "" Then GetPDFFile = sExpFile
        Exit Function
Lab_Error:
    End Function

    Public Function ExportToPDF(ByRef oAvax As AxAvax.AxcAvax, ByRef sPDFFile As String) As Boolean
        m_Avax = oAvax
        Call Init()
        If Preview1.PrintToPDF(sPDFFile) = True Then
            ShellExecute(0, vbNullString, sPDFFile, vbNullString, vbNullString, 1)
            ExportToPDF = True
        End If
    End Function

    Private Sub Preview1_PrintingPage(ByVal sender As Object, ByVal e As AxavPreview.__Preview_PrintingPageEvent) Handles Preview1.PrintingPage
        Label1.Text = "Page " & e.lNowPage & " of " & e.lMaxPage
        If e.lNowPage <= Preview1.MaxPage Then
            Preview1.set_PreviewPage(e.lNowPage)
        End If
    End Sub

    Private Sub FrmPrintPreview_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class