Option Strict Off
Option Explicit On
Module modAvax
	
	Public Declare Function ShellExecute Lib "shell32.dll"  Alias "ShellExecuteA"(ByVal hwnd As Integer, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Integer) As Integer
	
	Public Declare Function WinHelp Lib "user32"  Alias "WinHelpA"(ByVal hwnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, ByVal dwData As Integer) As Integer
	
	Private Const SW_SHOWNORMAL As Integer = 1
	Public Const HELP_CONTENTS As Integer = &H3
	
	Public Sub SendMail(Optional ByRef Address As String = "", Optional ByRef Subject As String = "", Optional ByRef Body As String = "", Optional ByRef cc As String = "", Optional ByRef BCC As String = "", Optional ByRef hwnd As Integer = 0)
		Dim strCommand As String
		If Len(Subject) Then strCommand = "&Subject=" & Subject
		If Len(Body) Then strCommand = strCommand & "&Body=" & Body
		If Len(cc) Then strCommand = strCommand & "&CC=" & cc
		If Len(BCC) Then strCommand = strCommand & "&BCC=" & BCC
		strCommand = "mailto:" & Address & strCommand
		Call ShellExecute(hwnd, "open", strCommand, vbNullString, vbNullString, SW_SHOWNORMAL)
	End Sub
	
	Public Function AskForSaveFile(ByVal sFile As String, ByRef Cancel As Short) As Boolean
		Dim sMsg As String
		Dim iAns As Short
		sMsg = "Do you want to save the current drawing?"
		If sFile = "" Then sFile = "Untitle drawing..."
		iAns = MsgBox(sMsg, MsgBoxStyle.Exclamation + MsgBoxStyle.YesNoCancel, sFile)
		Select Case iAns
			Case MsgBoxResult.No
				Cancel = 0
			Case MsgBoxResult.Yes
				AskForSaveFile = True
				Cancel = 0
			Case MsgBoxResult.Cancel
				Cancel = 1
		End Select
	End Function
	
    Public Sub swap(ByRef a As Object, ByRef b As Object)

        Dim c As Object
        c = b
        b = a
        a = c

    End Sub

    Function FParseExt(ByVal sImpFile As String) As String
        Dim iCnt As Short
        sImpFile = RTrim(sImpFile)
        If sImpFile = "" Then Exit Function
        If InStr(sImpFile, ".") = 0 Then Exit Function
        For iCnt = Len(sImpFile) To 1 Step -1
            If Mid(sImpFile, iCnt, 1) = "." Then
                FParseExt = Mid(sImpFile, iCnt + 1)
                Exit Function
            End If
        Next iCnt
    End Function

    Function IsFile(ByRef sFile As String) As Boolean
        Dim lLen As Integer
        On Error GoTo Lab_Error
        If sFile = "" Then Exit Function
        lLen = FileLen(sFile)
        IsFile = True
        Exit Function
Lab_Error:
        IsFile = False
    End Function
End Module